-- safe sql commands
-- use INSERT ... ON DUPLICATE KEY UPDATE to prevent duplicate errors

-- ===============================
--   landings
-- ===============================
INSERT INTO `landings` (`id`, `url`, `preview_img`, `enable`, `created_at`) VALUES
(1, 'default', '/store/landing_builder/landing_1//preview_img.jpg', 1, 1748938121)
ON DUPLICATE KEY UPDATE 
    `url` = VALUES(`url`),
    `preview_img` = VALUES(`preview_img`),
    `enable` = VALUES(`enable`),
    `created_at` = VALUES(`created_at`);

-- ===============================
--   landing_builder_components
-- ===============================
REPLACE INTO `landing_builder_components` (`id`, `name`, `category`) VALUES
(1, 'two_columns_hero', 'hero'),
(2, 'statistics', 'statistics'),
(3, 'featured_courses', 'courses'),
(4, 'trending_categories', 'categories'),
(5, 'newest_courses', 'courses'),
(6, 'best_selling_courses', 'courses'),
(7, 'best_rated_courses', 'courses'),
(8, 'discounted_courses', 'courses'),
(9, 'free_courses', 'courses'),
(10, 'instructors', 'instructors'),
(11, 'blog', 'blog_posts'),
(12, 'vertical_spacer', 'miscellaneous');

-- ===============================
--   landing_components
-- ===============================
INSERT INTO `landing_components` (`id`, `landing_id`, `component_id`, `preview`, `enable`, `order`) VALUES
(1, 1, 1, NULL, 1, 0),
(2, 1, 2, NULL, 1, 1),
(3, 1, 6, NULL, 1, 7),
(4, 1, 12, NULL, 1, 2),
(5, 1, 12, NULL, 1, 4),
(6, 1, 12, NULL, 1, 6),
(7, 1, 7, NULL, 1, 13),
(8, 1, 12, NULL, 1, 12),
(9, 1, 12, NULL, 1, 14),
(11, 1, 12, NULL, 1, 17),
(12, 1, 8, NULL, 1, 9),
(13, 1, 9, NULL, 1, 11),
(14, 1, 12, NULL, 1, 8),
(15, 1, 12, NULL, 1, 10)
ON DUPLICATE KEY UPDATE 
    `landing_id` = VALUES(`landing_id`),
    `component_id` = VALUES(`component_id`),
    `preview` = VALUES(`preview`),
    `enable` = VALUES(`enable`),
    `order` = VALUES(`order`);

-- ===============================
--   landing_component_translations
-- ===============================
INSERT INTO `landing_component_translations` (`id`, `landing_component_id`, `locale`, `content`) VALUES
(1, 1, 'en', '{"upper_cta":{"badge_text":"New","main_text":"Our Design Course Released!","icon":"bol-video-circle","url":"\\/classes"},"main_content":{"title_line_1":"Learn","title_line_2":"and Build Your Expertise","description":"Gain practical, real-world knowledge in different subjects, guided by expert instructors. Whether you\'re a beginner or upskilling, our courses help you grow with confidence and unlock your creative potential.","primary_button":{"label":"Explore Courses","icon":"bul-video-horizontal","url":"\\/classes"},"secondary_button":{"label":"Book a Meeting","icon":"bul-video","url":"\\/instructor-finder"},"highlight_words":{"pPFcH":"Design","fLaeR":"Marketing","JETPX":"Development","DlVgr":"UI\\/UX"}},"students_widget":{"title":"Loved by 2,500+ Happy Learners","url":"\\/login"},"image_content":{"type":"image","image":"\\/store\\/landing_builder\\/landing_1\\/1\\/hero_image_Tz0.jpg","overlay_image":"\\/store\\/landing_builder\\/landing_1\\/1\\/hero_overlay_FMv.png","spinning_image":"\\/store\\/landing_builder\\/landing_1\\/1\\/revolverimage_Fdv.svg"},"background":"\\/store\\/landing_builder\\/landing_1\\/1\\/hero_background_xfq.svg","students_widget_avatars":{"GKpNG":"\\/store\\/landing_builder\\/landing_1\\/1\\/ZNzOr_Group_2038.png","SXayp":"\\/store\\/landing_builder\\/landing_1\\/1\\/MB7pW_Group_2039.png","AlqmP":"\\/store\\/landing_builder\\/landing_1\\/1\\/boqCl_Group_2044.png","fQZwb":"\\/store\\/landing_builder\\/landing_1\\/1\\/U70f5_Group_2045.png","iliIZ":"\\/store\\/landing_builder\\/landing_1\\/1\\/5bLDZ_Group_2046.png"}}'),
(2, 2, 'en', '{"statistics":{"QbGNb":{"title":"Skillful Instructors","icon":"bul-briefcase","data_type":"semi_real","data_source":"number_of_instructors","start_from":"250","manual_data":null},"YOFAm":{"title":"Happy Students","icon":"bul-teacher","data_type":"semi_real","data_source":"number_of_students","start_from":"500","manual_data":null},"repCq":{"title":"Professional Courses","icon":"bul-video-play","data_type":"real","data_source":"number_of_courses","start_from":null,"manual_data":null},"JLmBF":{"title":"Official Organizations","icon":"bul-building","data_type":"real","data_source":"number_of_organizations","start_from":null,"manual_data":null},"record":{"title":null,"icon":null,"data_type":"real","data_source":"number_of_instructors","start_from":null,"manual_data":null}},"background":"\\/store\\/landing_builder\\/landing_1\\/2\\/stats_bg_5uH.png","background_color":"secondary"}'),
(3, 3, 'en', '{"main_content":{"title":"Bestsellers Chosen by Our Students","subtitle":"Explore our top-selling courses, chosen by thousands of learners who\\u2019ve enrolled and benefited. These bestsellers reflect what\\u2019s most in-demand and valuable across our platform.","icon":"\\/store\\/landing_builder\\/landing_1\\/5\\/topselling_overlay_Z8L.png"},"background":"\\/store\\/landing_builder\\/landing_1\\/5\\/topselling_background_pVh.png"}'),
(4, 4, 'en', '{"space_number":"80"}'),
(5, 5, 'en', '{"space_number":"80"}'),
(6, 6, 'en', '{"space_number":"100"}'),
(7, 8, 'en', '{"space_number":"100"}'),
(8, 7, 'en', '{"main_content":{"title":"Top Rated by Our Students","subtitle":"Discover the most highly rated courses, trusted by learners for quality content, expert instruction, and outstanding learning experiences across a wide range of topics.","icon":"\\/store\\/landing_builder\\/landing_1\\/9\\/bestrated_overlay_4Ss.png"},"background":"\\/store\\/landing_builder\\/landing_1\\/9\\/topselling_background_xZD.png"}'),
(9, 9, 'en', '{"space_number":"60"}'),
(11, 12, 'en', '{"main_content":{"title":"Discounted Courses","subtitle":"Save more now with top courses at discounts","icon":"\\/store\\/landing_builder\\/landing_13\\/391\\/discounted_overlay_aol.png"},"cta_section":{"title_bold_text":"Over $240K Saved","title_regular_text":"With Exclusive Course Discounts","icon":"bul-verify","button":{"label":"View More","icon":"bul-discount-circle","url":"\\/classes?discount=on"}},"background":"\\/store\\/landing_builder\\/landing_13\\/391\\/discounted_bg_s3Z.svg"}'),
(12, 11, 'en', '{"space_number":"60"}'),
(13, 13, 'en', '{"main_content":{"title":"Free Courses","subtitle":"Access top-quality free courses anytime, expand your skills, and learn without spending a single dollar"},"cta_section":{"title":"Need skills but budget constraints?","description":"Explore top free courses now and keep advancing your career path with practical, valuable new skills","link_title":"Explore Free Courses","url":"\\/classes?free=on","icon":"\\/store\\/landing_builder\\/landing_13\\/392\\/free_courses_overlay_79X.png"},"background":"\\/store\\/landing_builder\\/landing_13\\/392\\/free_courses_bg_4Mq.svg"}'),
(14, 14, 'en', '{"space_number":"100"}'),
(15, 15, 'en', '{"space_number":"100"}')
ON DUPLICATE KEY UPDATE 
    `landing_component_id` = VALUES(`landing_component_id`),
    `locale` = VALUES(`locale`),
    `content` = VALUES(`content`);

-- ===============================
--   landing_translations
-- ===============================
INSERT INTO `landing_translations` (`id`, `landing_id`, `locale`, `title`) VALUES
(1, 1, 'en', 'Lite (Included)')
ON DUPLICATE KEY UPDATE 
    `landing_id` = VALUES(`landing_id`),
    `locale` = VALUES(`locale`),
    `title` = VALUES(`title`);

-- ===============================
--   theme_colors_fonts
-- ===============================
INSERT INTO `theme_colors_fonts` (`id`, `type`, `title`, `content`, `created_at`) VALUES
(1, 'color', 'Blue (Default)', '{"light":{"primary":"#0170ff","primary_saturated":"#67a9ff","secondary":"#0e2145","accent":"#fe6257","success":"#3fcd82","info":"#67a9ff","warning":"#ffa200","danger":"#f63c3c","dark":"#121f3e","black":"#000000","white":"#ffffff","gray_100":"#fafcff","gray_200":"#f0f4f9","gray_300":"#e9edf3","gray_400":"#cdd5e2","gray_500":"#97a7bf","gray":"#f5f8f9","section_bg":"#eaf0f3"},"dark":{"primary":"#3e93ff","primary_saturated":"#8dbeff","secondary":"#2658b7","accent":"#ff8077","success":"#5ade98","info":"#8dbeff","warning":"#ffb32d","danger":"#fe6363","dark":"#aab8c5","black":"#e1eaf6","white":"#1e1f26","gray_100":"#272832","gray_200":"#30313e","gray_300":"#3e404e","gray_400":"#5d5f72","gray_500":"#8391a2","gray":"#17181e","section_bg":"#2d323a"}}', 1748879802),
(2, 'font', 'Default', '{"main":{"regular":"\\/store\\/1\\/fonts\\/Gilroy-Regular.woff2","bold":"\\/store\\/1\\/fonts\\/Gilroy-Bold.woff2","medium":"\\/store\\/1\\/fonts\\/Gilroy-Medium.woff2"},"rtl":{"regular":"\\/store\\/1\\/fonts\\/Tajawal-Regular.woff2","bold":"\\/store\\/1\\/fonts\\/Tajawal-Bold.woff2","medium":"\\/store\\/1\\/fonts\\/Tajawal-Medium.woff2"}}', 1748880740)
ON DUPLICATE KEY UPDATE 
    `type` = VALUES(`type`),
    `title` = VALUES(`title`),
    `content` = VALUES(`content`),
    `created_at` = VALUES(`created_at`);

-- ===============================
--   theme_headers_footers
-- ===============================
REPLACE INTO `theme_headers_footers` (`id`, `type`, `component_name`, `created_at`) VALUES
(1, 'header', 'header_1', 1748875817),
(2, 'footer', 'footer_1', 1748875817);

-- ===============================
--   theme_header_footer_translations
-- ===============================
INSERT INTO `theme_header_footer_translations` (`id`, `theme_header_footer_id`, `locale`, `title`, `content`) VALUES
(1, 1, 'en', 'Header 1 (Default)', '{"top_navbar":{"phone":"+1 (323) 555-9876","email":"mail@rocket-soft.org","link_1":{"title":"Login","url":"\\/login"},"link_2":{"title":"Register","url":"\\/register"},"show_color_mode":"on"},"specific_links":{"RUYtv":{"title":"Home","url":"\\/"},"tZblv":{"title":"Courses","url":"\\/classes?sort=newest"},"rOvAj":{"title":"Instructors","url":"\\/instructor-finder"},"qeAzK":{"title":"Store","url":"\\/products"},"GZDCs":{"title":"Forums","url":"\\/forums"},"record":{"title":null,"url":null}},"specific_buttons":{"BFKTm":{"user_role":"for_guest","title":"Start Learning","url":"\\/login","icon":"bul-teacher"},"UsxeP":{"user_role":"1","title":"Become Instructor","url":"\\/become-instructor","icon":"bul-teacher"},"MYTBW":{"user_role":"2","title":"Admin Panel","url":"\\/admin","icon":"bul-setting-2"},"yVQQV":{"user_role":"3","title":"Create a Course","url":"\\/panel\\/webinars\\/new","icon":"bul-video-add"},"fQclX":{"user_role":"4","title":"Create a Course","url":"\\/panel\\/webinars\\/new","icon":"bul-video-add"},"record":{"user_role":null,"title":null,"url":null,"icon":null}}}'),
(2, 2, 'en', 'Footer 1 (Default)', '{"newsletter":{"enable":"on","title":"Subscribe to Our Newsletter","subtitle":"Receive expert insights, course updates, and learning resources directly in your inbox and get notified","button_text":"Join","emoji":"\\/store\\/themes\\/footers\\/2\\/happy_emoji_zoa.svg"},"cta":{"pre_title":"Let\\u2019s get started now!","title":"Take the First Step Towards Mastery!","button":{"label":"Enroll on Courses","icon":"bul-teacher","url":"\\/classes"},"emoji":"\\/store\\/themes\\/footers\\/2\\/power_emoji_42t.svg"},"contact":{"section_title":"Contact US","address":"1234 Sunset Blvd, Suite 567 Los Angeles, CA 90026 United States","phone":"+1 (323) 555-9876","email":"mail@lms.rocket-soft.org","mobile":"+1 (213) 555-4321"},"links_1_section_title":"Additional Links","links_2_section_title":"Popular Categories","copyright_text":"\\u00a9 2025 Rocket Soft. All Rights Reserved. Empowering Learning Worldwide.","specific_links":{"LITim":{"title":"Login","url":"\\/login"},"qJFNp":{"title":"Register","url":"\\/register"},"izISj":{"title":"Contact","url":"\\/contact"},"cdkPb":{"title":"Certificate Validation","url":"\\/certificate_validation"},"OKAqQ":{"title":"Become Instructor","url":"\\/become-instructor"},"DebJE":{"title":"About","url":"\\/pages\\/about"},"aMQau":{"title":"Terms and Policies","url":"\\/pages\\/terms"},"record":{"title":null,"url":null}},"specific_links_2":{"dzQOe":{"title":"Development","url":"\\/categories\\/Development"},"pgxMd":{"title":"Business","url":"\\/categories\\/Business"},"ZveCn":{"title":"Marketing","url":"\\/categories\\/Marketing"},"QXKsq":{"title":"Lifestyle","url":"\\/categories\\/Lifestyles"},"FCJal":{"title":"Health","url":"\\/categories\\/Health-and-Fitness"},"SVtaA":{"title":"Academics","url":"\\/categories\\/Academics"},"PivsB":{"title":"Design","url":"\\/categories\\/Design"},"record":{"title":null,"url":null}},"social_media":["Instagram","Whatsapp","Twitter","Facebook"],"background":"\\/store\\/themes\\/footers\\/2\\/footer_background_7gn.png","dark_mode_background":"\\/store\\/themes\\/footers\\/2\\/footer_background_7gn.png","background_color":"secondary"}')
ON DUPLICATE KEY UPDATE 
    `theme_header_footer_id` = VALUES(`theme_header_footer_id`),
    `locale` = VALUES(`locale`),
    `title` = VALUES(`title`),
    `content` = VALUES(`content`);

    -- ===============================
--   themes
-- ===============================
INSERT INTO `themes` (`id`, `title`, `preview_image`, `default_color_mode`, `color_id`, `font_id`, `header_id`, `footer_id`, `home_landing_id`, `contents`, `is_default`, `enable`, `created_at`) VALUES
(1, 'Lite (Included)', '/store/1/default_images/themes/lite-preview.jpg', 'light', 1, 2, 1, 2, 1, '{"card_styles":{"course":"grid_card_1","product":"grid_card_1","bundle":"grid_card_1","upcoming_course":"grid_card_1","blog_post":"grid_card_1","instructor":"grid_card_1","organization":"grid_card_1"},"images":{"admin_login":"\\/store\\/1\\/themes\\/general\\/admin_login.jpg","admin_dashboard":"\\/store\\/1\\/themes\\/general\\/admin_dashboard.png","search":"\\/store\\/1\\/themes\\/general\\/search_background.jpg","tags":"\\/store\\/1\\/themes\\/general\\/tags_background.jpg","categories":"\\/store\\/1\\/themes\\/general\\/categories_background.jpg","become_instructor":"\\/store\\/1\\/themes\\/general\\/become_instructor_background.jpg","certificate_validation":"\\/store\\/1\\/themes\\/general\\/certificate_validation.jpg","certificate_validation_overlay_image":"\\/store\\/1\\/themes\\/general\\/certificate_validation_overlay.png","instructors_lists":"\\/store\\/1\\/themes\\/general\\/instructors_background.jpg","instructors_header_overlay_image":"\\/store\\/1\\/themes\\/general\\/instructors_overlay.png","organizations_lists":"\\/store\\/1\\/themes\\/general\\/organizations_background.jpg","organizations_header_overlay_image":"\\/store\\/1\\/themes\\/general\\/organizations_overlay.png","user_cover":"\\/store\\/1\\/themes\\/general\\/user_profile_background.jpg","products_lists":"\\/store\\/1\\/themes\\/general\\/products_list_background.jpg","products_lists_overlay_image":"\\/store\\/1\\/themes\\/general\\/products_overlay.png","upcoming_courses_lists":"\\/store\\/1\\/themes\\/general\\/upcoming_courses_background.jpg","upcoming_courses_lists_overlay_image":"\\/store\\/1\\/themes\\/general\\/upcoming_courses_overlay.png","categories_courses_lists_featured_courses_background":"\\/store\\/1\\/themes\\/general\\/featured_courses_background.svg","categories_courses_lists_featured_courses_overlay_image":"\\/store\\/1\\/themes\\/general\\/featured_courses_overlay.png","bundles_lists":"\\/store\\/1\\/themes\\/general\\/bundles_background.jpg","bundles_lists_overlay_image":"\\/store\\/1\\/themes\\/general\\/bundles_overlay.png","blog_lists":"\\/store\\/1\\/themes\\/general\\/blog_background.jpg","blog_lists_overlay_image":"\\/store\\/1\\/themes\\/general\\/blog_overlay.png","form_default_cover":"\\/store\\/1\\/themes\\/general\\/form_background.jpg","form_default_overlay_image":"\\/store\\/1\\/themes\\/general\\/form_overlay.png","form_default_header_icon":"\\/store\\/1\\/themes\\/general\\/form_default_icon.svg","meeting_booking_step_1_image":"\\/store\\/1\\/themes\\/general\\/meeting_booking_step1_overlay.png","meeting_booking_step_2_image":"\\/store\\/1\\/themes\\/general\\/meeting_booking_step2_overlay.png","classes_lists":"\\/store\\/1\\/themes\\/general\\/classes_background.jpg","classes_lists_overlay_image":"\\/store\\/1\\/themes\\/general\\/courses_overlay.png","reward_courses":"\\/store\\/1\\/themes\\/general\\/reward_courses_background.jpg","reward_courses_overlay_image":"\\/store\\/1\\/themes\\/general\\/rewards_overlay.png"},"authentication_pages":{"style":"theme_1","slider_background_image":"\\/store\\/1\\/themes\\/general\\/authentication_background.svg","slider_contents":{"uHuuS":{"title":"Instant Certificate Access","subtitle":"Download certificates right after completion","image":"\\/store\\/1\\/themes\\/general\\/authentication_slide1.png"},"axuTg":{"title":"Affordable Quality Education","subtitle":"High-value courses at accessible prices","image":"\\/store\\/1\\/themes\\/general\\/authentication_slide2.png"},"RuDfz":{"title":"Advance Your Career","subtitle":"Build your resume with proven expertise","image":"\\/store\\/1\\/themes\\/general\\/authentication_slide3.png"}}},"custom_css":null,"custom_js":null}', 1, 1, 1751359567)
ON DUPLICATE KEY UPDATE 
    `title` = VALUES(`title`),
    `preview_image` = VALUES(`preview_image`),
    `default_color_mode` = VALUES(`default_color_mode`),
    `color_id` = VALUES(`color_id`),
    `font_id` = VALUES(`font_id`),
    `header_id` = VALUES(`header_id`),
    `footer_id` = VALUES(`footer_id`),
    `home_landing_id` = VALUES(`home_landing_id`),
    `contents` = VALUES(`contents`),
    `is_default` = VALUES(`is_default`),
    `enable` = VALUES(`enable`),
    `created_at` = VALUES(`created_at`);
